% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapper.R
\name{setSimulationValues}
\alias{setSimulationValues}
\title{Changes values of the current simulation}
\usage{
setSimulationValues(simplace, parameterList = NULL, simulationNumber = 1)
}
\arguments{
\item{simplace}{handle to the SimplaceWrapper object returned by \code{\link{initSimplace}}}

\item{parameterList}{a list with the parameter name as key and parametervalue as value}

\item{simulationNumber}{number of simulation in the queue whose parameters should be set (default first simulation)}
}
\value{
No return value, called for the side effect of changing parameters in the current simulation
}
\description{
Sets values of arbitrary SimVariables in a simplace simulation.
Useful if you want to couple simplace with another simulation 
and interchange values daily.
}
\examples{
\dontrun{
for(i in 1:365)
{
  param <- list(vBaseLUE=3.0 + i/2000)
  setSimulationValues(simplace,param)
  stepSimulation(simplace)
}
}

}
