% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/si_model.R
\name{si_predict}
\alias{si_predict}
\title{Predict spatial interaction based on pre-trained model}
\usage{
si_predict(
  od,
  model,
  constraint_production,
  constraint_attraction,
  constraint_total,
  output_col = "interaction",
  ...
)
}
\arguments{
\item{od}{A data frame representing origin-destination data, e.g. as created by
\code{\link[=si_to_od]{si_to_od()}}}

\item{model}{A model object, e.g. from \code{\link[=lm]{lm()}} or \code{\link[=glm]{glm()}}}

\item{constraint_production}{Character representing column in \code{od}.
This argument, when set, ensures that the outputs are 'production constrained':
the total 'interaction' (e.g. n. trips) for all OD pairs is set such that
the total for each zone of origin cannot go above this value.}

\item{constraint_attraction}{Character representing column in \code{od}.
This argument, when set, ensures that the outputs are 'attraction constrained':
the total 'interaction' (e.g. n. trips) for all OD pairs is set such that
the sum of trips to destination is equal to the mean value per destination.}

\item{constraint_total}{Single number representing the total interaction.
This argument, when set, ensures that the sum of the interaction
calculated will equal the value given.}

\item{output_col}{Character string containing the name of the new output
column. \code{"interaction"} by default.}

\item{...}{Arguments passed to \code{fun}}
}
\value{
An sf data frame
}
\description{
Predict spatial interaction based on pre-trained model
}
\examples{
od = si_to_od(si_zones, si_zones, max_dist = 4000)
m = lm(od$origin_all ~ od$origin_bicycle)
od_updated = si_predict(od, m)
}
\seealso{
si_calculate
}
