% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_data.r
\name{missing_data}
\alias{missing_data}
\alias{dropout_missing}
\alias{random_missing}
\alias{mar_missing}
\title{Missing Data Functions}
\usage{
missing_data(sim_data, resp_var = "sim_data",
  new_outcome = "sim_data2", clust_var = NULL, within_id = NULL,
  miss_prop = NULL, dropout_location = NULL, type = c("dropout",
  "random", "mar"), miss_cov, mar_prop)

dropout_missing(sim_data, resp_var = "sim_data",
  new_outcome = "sim_data2", clust_var = "clustID",
  within_id = "withinID", miss_prop = NULL, dropout_location = NULL)

random_missing(sim_data, resp_var = "sim_data",
  new_outcome = "sim_data2", miss_prop, clust_var = NULL,
  within_id = "withinID")

mar_missing(sim_data, resp_var = "sim_data", new_outcome = "sim_data2",
  miss_cov, mar_prop)
}
\arguments{
\item{sim_data}{Simulated data frame}

\item{resp_var}{Character string of response variable with complete data.}

\item{new_outcome}{Character string of new outcome variable name that includes
the missing data.}

\item{clust_var}{Cluster variable used for the grouping, set to 
NULL by default which means no clustering.}

\item{within_id}{ID variable within each cluster.}

\item{miss_prop}{Proportion of missing data overall}

\item{dropout_location}{A vector the same length as the number of clusters 
representing the number of data observations for each individual.}

\item{type}{The type of missing data to generate, currently supports
droput, random, or missing at random (mar) missing data.}

\item{miss_cov}{Covariate that the missing values are based on.}

\item{mar_prop}{Proportion of missing data for each unique value 
specified in the miss_cov argument.}
}
\description{
Function that inputs simulated data and returns data frame with 
new response variable that includes missing data. Missing data types
incorporated include dropout missing data, missing at random, and 
random missing data.
}
