% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_ail_pedigree.R
\name{sim_ail_pedigree}
\alias{sim_ail_pedigree}
\title{Simulate AIL pedigree}
\usage{
sim_ail_pedigree(
  ngen = 12,
  npairs = 30,
  nkids_per = 5,
  design = c("nosib", "random")
)
}
\arguments{
\item{ngen}{Number of generations of outbreeding}

\item{npairs}{Number of breeding pairs at each generation}

\item{nkids_per}{Number of offspring per pair for the last
generation}

\item{design}{How to choose crosses: either random but avoiding
siblings, or completely at random}
}
\value{
A data frame with five columns: individual ID, mother ID,
father ID, sex, and generation.  Founders have \code{0} for mother
and father ID. Sex is coded 0 for female and 1 for male.
}
\description{
Simulate a pedigree for advanced intercross lines (a table of
individual, mom, dad, sex)
}
\details{
Advanced intercross lines (AIL) are generated from a pair of inbred lines.
We cross them and then cross the F1 to generate \code{npair} breeding pairs.
The subsequent \code{ngen} outbreeding generations then proceed by
crossing a male and female from the preceding generation (mated
completely at random, with \code{design="random"}, or avoiding
siblings, with \code{design="nosib"}). Each breeding pair gives a
single female and a single male to the next generation, except at
the last generation \code{nkids_per} offspring are mated, in equal
numbers male and female. (If \code{nkids_per} is an odd number, the
number of males and females in each sibship will differ by one,
alternating between sibships, with one additional female and then
one additional male.
}
\examples{
tab <- sim_ail_pedigree(12, 30)
}
\seealso{
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}},
\code{\link[=sim_ril_pedigree]{sim_ril_pedigree()}}, \code{\link[=sim_do_pedigree]{sim_do_pedigree()}},
\code{\link[=sim_4way_pedigree]{sim_4way_pedigree()}}
}
\keyword{datagen}
