% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimPhiN}
\alias{SimPhiN}
\title{Simulate Random Drift Matrices
from the Multivariate Normal Distribution}
\usage{
SimPhiN(n, phi, vcov_phi_vec_l)
}
\arguments{
\item{n}{Positive integer.
Number of replications.}

\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).}

\item{vcov_phi_vec_l}{Numeric matrix.
Cholesky factorization (\code{t(chol(vcov_phi_vec))})
of the sampling variance-covariance matrix
\eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)}.}
}
\description{
This function simulates random drift matrices
from the multivariate normal distribution.
The function ensures that the generated drift matrices are stable
using \code{\link[=TestPhi]{TestPhi()}}.
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
n <- 10
vcov_phi_vec_l <- t(chol(0.001 * diag(9)))
SimPhiN(n = n, phi = phi, vcov_phi_vec_l = vcov_phi_vec_l)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{SimBetaN}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{TestPhi}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{simStateSpace}
