% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-sim-ssm-lin-growth.R
\name{SimSSMLinGrowth}
\alias{SimSSMLinGrowth}
\title{Simulate Data from a Linear Growth Curve Model}
\usage{
SimSSMLinGrowth(
  n,
  mu0,
  sigma0,
  theta,
  gamma_y = NULL,
  gamma_eta = NULL,
  x = NULL,
  type = 0,
  time
)
}
\arguments{
\item{n}{Positive integer.
Number of individuals.}

\item{mu0}{Numeric vector.
A vector of length two.
The first element is the mean of the intercept,
and the second element is the mean of the slope.}

\item{sigma0}{Numeric matrix.
The covariance matrix
of the intercept and the slope.}

\item{theta}{Numeric.
The common measurement error variance.}

\item{gamma_y}{Numeric matrix.
Matrix relating the values of the covariate matrix
at time \code{t} to \code{y} at time \code{t}
(\eqn{\boldsymbol{\Gamma}_{\mathbf{y}}}).}

\item{gamma_eta}{Numeric matrix.
Matrix relating the values of the covariate matrix
at time \code{t} to the latent variables (intercept and slope) at time \code{t}
(\eqn{\boldsymbol{\Gamma}_{\boldsymbol{\eta}}}).}

\item{x}{A list of length \code{n} of numeric matrices.
Each element of the list
is a matrix of observed covariates in \code{type = 1} or \code{type = 2}.
The number of rows in each matrix should be equal to \code{time}.}

\item{type}{Integer.
State space model type.
See Details for more information.}

\item{time}{Positive integer.
Number of time points to simulate.}
}
\value{
Returns an object of class \code{simstatespace}
which is a list with the following elements:
\itemize{
\item \code{call}: Function call.
\item \code{args}: Function arguments.
\item \code{data}: Generated data which is a list of length \code{n}.
Each element of \code{data} is a list with the following elements:
\itemize{
\item \code{id}: A vector of ID numbers of length \code{t}.
\item \code{time}: A vector time points of length \code{t}.
\item \code{y}: A \code{t} by \code{k} matrix of values for the manifest variables.
\item \code{eta}: A \code{t} by \code{p} matrix of values for the latent variables.
\item \code{x}: A \code{t} by \code{j} matrix of values for the covariates.
}
\item \code{fun}: Function used.
}
}
\description{
This function simulates data
from a linear growth curve model
for \code{n > 1} individuals.
}
\details{
\subsection{Type 0}{

The measurement model is given by
\deqn{
    y_{i, t}
    =
    \left(
    \begin{array}{cc}
      1 & 0 \\
    \end{array}
    \right)
    \left(
    \begin{array}{c}
      \eta_{0_{i, t}} \\
      \eta_{1_{i, t}} \\
    \end{array}
    \right)
    +
    \boldsymbol{\varepsilon}_{i, t}
    \quad
    \mathrm{with}
    \quad
    \boldsymbol{\varepsilon}_{i, t}
    \sim
    \mathcal{N}
    \left(
    0,
    \theta
    \right)
  }
where \eqn{y_{i, t}}, \eqn{\eta_{0_{i, t}}},
\eqn{\eta_{1_{i, t}}},
and \eqn{\boldsymbol{\varepsilon}_{i, t}}
are random variables and
\eqn{\theta} is a model parameter.
\eqn{y_{i, t}} is a vector of observed random variables
at time \eqn{t} and individual \eqn{i},
\eqn{\eta_{0_{i, t}}}
and
\eqn{\eta_{1_{i, t}}} form a vector of latent random variables
at time \eqn{t} and individual \eqn{i},
and \eqn{\boldsymbol{\varepsilon}_{i, t}}
is a vector of random measurement errors
at time \eqn{t} and individual \eqn{i}.
\eqn{\theta} is the variance of
\eqn{\boldsymbol{\varepsilon}}.

The dynamic structure is given by
\deqn{
    \left(
    \begin{array}{c}
    \eta_{0_{i, t}} \\
    \eta_{1_{i, t}} \\
    \end{array}
    \right)
    =
    \left(
    \begin{array}{cc}
      1 & 1 \\
      0 & 1 \\
    \end{array}
    \right)
    \left(
    \begin{array}{c}
    \eta_{0_{i, t - 1}} \\
    \eta_{1_{i, t - 1}} \\
    \end{array}
    \right) .
  }

The mean vector and covariance matrix of the intercept and slope
are captured in the mean vector and covariance matrix
of the initial condition given by
\deqn{
    \boldsymbol{\mu}_{\boldsymbol{\eta} \mid 0}
    =
    \left(
    \begin{array}{c}
      \mu_{\eta_{0}} \\
      \mu_{\eta_{1}} \\
    \end{array}
    \right) \quad \mathrm{and,}
  }

\deqn{
    \boldsymbol{\Sigma}_{\boldsymbol{\eta} \mid 0}
    =
    \left(
    \begin{array}{cc}
      \sigma^{2}_{\eta_{0}} &
      \sigma_{\eta_{0}, \eta_{1}} \\
      \sigma_{\eta_{1}, \eta_{0}} &
      \sigma^{2}_{\eta_{1}} \\
    \end{array}
    \right) .
  }
}

\subsection{Type 1}{

The measurement model is given by
\deqn{
    y_{i, t}
    =
    \left(
    \begin{array}{cc}
      1 & 0 \\
    \end{array}
    \right)
    \left(
    \begin{array}{c}
      \eta_{0_{i, t}} \\
      \eta_{1_{i, t}} \\
    \end{array}
    \right)
    +
    \boldsymbol{\varepsilon}_{i, t}
    \quad
    \mathrm{with}
    \quad
    \boldsymbol{\varepsilon}_{i, t}
    \sim
    \mathcal{N}
    \left(
    0,
    \theta
    \right) .
  }

The dynamic structure is given by
\deqn{
    \left(
    \begin{array}{c}
    \eta_{0_{i, t}} \\
    \eta_{1_{i, t}} \\
    \end{array}
    \right)
    =
    \left(
    \begin{array}{cc}
      1 & 1 \\
      0 & 1 \\
    \end{array}
    \right)
    \left(
    \begin{array}{c}
    \eta_{0_{i, t - 1}} \\
    \eta_{1_{i, t - 1}} \\
    \end{array}
    \right)
    +
    \boldsymbol{\Gamma}_{\boldsymbol{\eta}}
    \mathbf{x}_{i, t}
  }
where
\eqn{\mathbf{x}_{i, t}} is a vector of covariates
at time \eqn{t} and individual \eqn{i},
and \eqn{\boldsymbol{\Gamma}_{\boldsymbol{\eta}}} is the coefficient matrix
linking the covariates to the latent variables.
}

\subsection{Type 2}{

The measurement model is given by
\deqn{
    y_{i, t}
    =
    \left(
    \begin{array}{cc}
      1 & 0 \\
    \end{array}
    \right)
    \left(
    \begin{array}{c}
      \eta_{0_{i, t}} \\
      \eta_{1_{i, t}} \\
    \end{array}
    \right)
    +
    \boldsymbol{\Gamma}_{\mathbf{y}}
    \mathbf{x}_{i, t}
    +
    \boldsymbol{\varepsilon}_{i, t}
    \quad
    \mathrm{with}
    \quad
    \boldsymbol{\varepsilon}_{i, t}
    \sim
    \mathcal{N}
    \left(
    0,
    \theta
    \right)
  }
where
\eqn{\boldsymbol{\Gamma}_{\mathbf{y}}} is the coefficient matrix
linking the covariates to the observed variables.

The dynamic structure is given by
\deqn{
    \left(
    \begin{array}{c}
    \eta_{0_{i, t}} \\
    \eta_{1_{i, t}} \\
    \end{array}
    \right)
    =
    \left(
    \begin{array}{cc}
      1 & 1 \\
      0 & 1 \\
    \end{array}
    \right)
    \left(
    \begin{array}{c}
    \eta_{0_{i, t - 1}} \\
    \eta_{1_{i, t - 1}} \\
    \end{array}
    \right)
    +
    \boldsymbol{\Gamma}_{\boldsymbol{\eta}}
    \mathbf{x}_{i, t} .
  }
}
}
\examples{
# prepare parameters
set.seed(42)
n <- 10
mu0 <- c(0.615, 1.006)
sigma0 <- matrix(
  data = c(
    1.932,
    0.618,
    0.618,
    0.587
  ),
  nrow = 2
)
theta <- 0.6
time <- 10
gamma_y <- matrix(data = 0.10, nrow = 1, ncol = 2)
gamma_eta <- matrix(data = 0.10, nrow = 2, ncol = 2)
x <- lapply(
  X = seq_len(n),
  FUN = function(i) {
    return(
      matrix(
        data = rnorm(n = 2 * time),
        ncol = 2
      )
    )
  }
)

# Type 0
ssm <- SimSSMLinGrowth(
  n = n,
  mu0 = mu0,
  sigma0 = sigma0,
  theta = theta,
  type = 0,
  time = time
)

plot(ssm)

# Type 1
ssm <- SimSSMLinGrowth(
  n = n,
  mu0 = mu0,
  sigma0 = sigma0,
  theta = theta,
  gamma_eta = gamma_eta,
  x = x,
  type = 1,
  time = time
)

plot(ssm)

# Type 2
ssm <- SimSSMLinGrowth(
  n = n,
  mu0 = mu0,
  sigma0 = sigma0,
  theta = theta,
  gamma_y = gamma_y,
  gamma_eta = gamma_eta,
  x = x,
  type = 2,
  time = time
)

plot(ssm)

}
\references{
Chow, S.-M., Ho, M. R., Hamaker, E. L., & Dolan, C. V. (2010).
Equivalence and differences between structural equation modeling
and state-space modeling techniques.
\emph{Structural Equation Modeling: A Multidisciplinary Journal},
17(2), 303–332.
\doi{10.1080/10705511003661553}
}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{OU2SSM}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMOU}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SimSSMVAR}()},
\code{\link{SimSSM}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{growth}
\keyword{sim}
\keyword{simStateSpace}
