% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate.R
\name{estimate_ET0_with_TmaxAndTmin}
\alias{estimate_ET0_with_TmaxAndTmin}
\title{Estimating ET0 with Tmax and Tmin}
\usage{
estimate_ET0_with_TmaxAndTmin(Tmean, Tmax, Tmin, Ra)
}
\arguments{
\item{Tmean}{mean temperature.}

\item{Tmax}{max temperature.}

\item{Tmin}{min temperature.}

\item{Ra}{extraterrestrial radiation [mm day-1].}
}
\value{
A vector for reference evapotranspiration (mm day-1).
}
\description{
When solar radiation data, relative humidity data and/or wind speed
   data are missing, they should be estimated using the procedures presented
   in this section.  As an alternative, ETo can be estimated using the
   Hargreaves ETo equation.
}
\note{
Units for both ETo and Ra in Equation 52 are mm day-1.  Equation 52
   should be verified in each new region by comparing with estimates by
   the FAO Penman-Monteith equation (Equation 6) at weather stations where
   solar radiation, air temperature, humidity, and wind speed are measured.
   If necessary, Equation 52 can be calibrated on a monthly or annual basis
   by determining empirical coefficients where ETo = a + b ETo Eq.52, where
   the Eq. 52 subscript refers to ETo predicted using Equation 52.  The
   coefficients a and b can be determined by regression analyses or by visual
   fitting.  In general, estimating solar radiation, vapor pressure and wind
   speed as described in Equations 48 to 51 and Table 4 and then utilizing
   these estimates in Equation 6 (the FAO Penman-Monteith equation) will
   provide somewhat more accurate estimates as compared to estimating ETo
   directly using Equation 52. This is due to the ability of the estimation
   equations to incorporate general climatic characteristics such as high or
   low wind speed or high or low relative humidity into the ETo estimate made
   using Equation 6. Equation 52 has a tendency to underpredict under high
   wind conditions (u2 > 3 m/s) and to overpredict under conditions of high
   relative humidity.
}
