% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_meteorlogy.R
\name{cal_atmosphericPressure}
\alias{cal_atmosphericPressure}
\title{Calculating atmospheric pressure}
\usage{
cal_atmosphericPressure(elevation)
}
\arguments{
\item{elevation}{elevation above sea level (m)}
}
\value{
A vector for atmospheric pressure (Kpa)
}
\description{
The atmospheric pressure, P, is the pressure exerted by the
   weight of the earth's atmosphere.
}
\details{
Assuming 20°C for a standard atmosphere. Evaporation at high altitudes
   is promoted due to low atmospheric pressure as expressed in thepsychrometric
   constant. The effect is, however, small and in the calculation procedures,
   the average value for a location is sufficient.
}
\examples{
cal_atmosphericPressure(100)
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
