% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Single_Kc.R
\name{Model_single_Kc}
\alias{Model_single_Kc}
\title{Simulation for evapotranspiration using single crop coefficient method}
\usage{
Model_single_Kc(data, param)
}
\arguments{
\item{data}{A data box. Contains the daily data required by the model. You can
refer to the function create_modelData()}

\item{param}{A list. Contains additional parameters.}
}
\value{
A list for the model result including a data frame of daily model result ,a list of plots, A data frame of summary data
}
\description{
Simulation for evapotranspiration using single crop coefficient method
}
\note{
The stages of data should include all four stages.
 If a crop has multiple growth cycles, each cycle should include all four stages.
}
\examples{
  library(simET)
  #--Data preparation
  data("FIalfalfa")
  #--Parameter preparation
  param_SingleKc<-list(Kc_mid=1.2,#Kcb for mid-season stage
                       Kc_end=1.15,#Kcb for late season stage
                       rootDepth=1.2,#Maximum root depth
                       #The soil type used for calculating
                       #Kc for initial stage
                       soil_type="coarse soil textures",
                       Dr_start=40,#Initial depletion of root layer
                       TAW=290,#Total available soil water of the root zone
                       p=0.55,#Evapotranspiration depletion factor
                       Field_capacity=420,#Field capacity of root layer
                       fw=1,#The fraction of the surface wetted
                       #Capillary rise model parameters
                       CR_param=c(420,-0.32,303,-0.16,-1.4,6.8,1.11,-0.98)
                       )
 #--Run model
 Re_SingleKc<- Model_single_Kc(data = FIalfalfa, param = param_SingleKc)
 #--The Result data
 Re_SingleKc$Result
 Re_SingleKc$Plot
 #--The goodness Of Fit
 estimate_goodnessOfFit(Sim = Re_SingleKc$Result$Sim_SoilWater,
                         Obs = Re_SingleKc$Result$SoilWater)
}
