% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{sg_get_nodes_p}
\alias{sg_get_nodes_p}
\alias{sg_get_edges_p}
\title{Get nodes}
\usage{
sg_get_nodes_p(proxy)

sg_get_edges_p(proxy)
}
\arguments{
\item{proxy}{An object of class \code{sigmajsProxy} as returned by \code{\link{sigmajsProxy}}.}
}
\description{
Retrieve nodes and edges from the widget.
}
\examples{
library(shiny)

nodes <- sg_make_nodes()
edges <- sg_make_edges(nodes)

ui <- fluidPage(
  actionButton("start", "Trigger layout"), # add the button
  sigmajsOutput("sg"),
  verbatimTextOutput("txt")
) 

server <- function(input, output){

  output$sg <- renderSigmajs({
    sigmajs() \%>\%
      sg_nodes(nodes, id, size, color) \%>\%
      sg_edges(edges, id, source, target)
  })

  observeEvent(input$start, {
    sigmajsProxy("sg") \%>\% # use sigmajsProxy!
      sg_get_nodes_p()
  })

  output$txt <- renderPrint({
    input$sg_nodes
  })

}
if(interactive()) shinyApp(ui, server) # run

}
