% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/break_join.R
\name{break_join}
\alias{break_join}
\title{Join tables based on overlapping intervals.}
\usage{
break_join(x, y, brk = character(), by = NULL, ...)
}
\arguments{
\item{x}{A data frame.}

\item{y}{Data frame containing desired reference information.}

\item{brk}{Name of column in \code{x} and \code{y} to join by via interval overlapping. Must be coercible to numeric.}

\item{by}{Joining variables, if needed. See \link[dplyr]{mutate-joins}.}

\item{...}{additional arguments automatically directed to \code{findInterval} and \code{dplyr::left_join}. No partial matching.}
}
\value{
An object of the same type as \code{x}.

\itemize{
  \item All \code{x} rows will be returned.
  \item All columns between \code{x} and \code{y} are returned.
  \item Rows in \code{y} are matched with \code{x} based on overlapping values of \code{brk} (e.g. \code{findInterval(x$brk, y$brk, ...)}).
}
}
\description{
User-friendly interface that synthesizes power of \code{dplyr::left_join} and \code{findInterval}.
}
\examples{
# joining USA + UK leaders with population time-series
break_join(us_uk_pop, us_uk_leaders, brk = c("date" = "start"))

# simple dataset
set.seed(1)
a <- data.frame(p = c(rep("A", 10), rep("B", 10)), q = runif(20, 0, 10))
b <- data.frame(p = c("A", "A", "B", "B"), q = c(3, 5, 6, 9), r = c("a1", "a2", "b1", "b2"))

break_join(a, b, brk = "q") # p identified as common variable automatically
break_join(a, b, brk = "q", by = "p") # same result
break_join(a, b, brk = "q", all.inside = TRUE) # note missing values have been filled

# joining toll prices with vehicle time-series

library(mopac)
library(dplyr, warn.conflicts = FALSE)
library(hms)

express \%>\%
  mutate(time_hms = as_hms(time)) \%>\%
  break_join(rates, brk = c("time_hms" = "time"))
}
