% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record-test.R
\name{record_test}
\alias{record_test}
\title{Launch test event recorder for a Shiny app}
\usage{
record_test(
  app = ".",
  ...,
  name = NULL,
  seed = NULL,
  load_timeout = NULL,
  shiny_args = list(),
  test_file = "test-shinytest2.R",
  open_test_file = rlang::is_interactive(),
  allow_no_input_binding = NULL,
  record_screen_size = TRUE,
  run_test = TRUE
)
}
\arguments{
\item{app}{A \code{\link{AppDriver}} object, or path to a Shiny
application.}

\item{...}{Must be empty. Allows for parameter expansion.}

\item{name}{Name provided to \code{\link{AppDriver}}. This value should be unique between all tests within a test file. If it is not unique, different expect methods may overwrite each other.}

\item{seed}{A random seed to set before running the app. This seed will also
be used in the test script.}

\item{load_timeout}{Maximum time to wait for the Shiny application to load, in
milliseconds. If a value is provided, it will be saved in the test script.}

\item{shiny_args}{A list of options to pass to \code{runApp()}. If a value
is provided, it will be saved in the test script.}

\item{test_file}{Base file name of the \pkg{testthat} test file.}

\item{open_test_file}{If \code{TRUE}, the test file will be opened in an editor
via \code{\link[=file.edit]{file.edit()}} before executing.}

\item{allow_no_input_binding}{This value controls if events without input
bindings are recorded.
\itemize{
\item If \code{TRUE}, events without input bindings are recorded.
\item If \code{FALSE}, events without input bindings are not recorded.
\item If \code{NULL} (default), if an updated input does not have a corresponding
\item input, a modal dialog will be shown asking if unbound input events should
\item be recorded.
}

See \code{\link{AppDriver}}\verb{$set_inputs()} for more information.}

\item{record_screen_size}{If \code{TRUE}, the screen size will be recorded when initialized and changed.}

\item{run_test}{If \code{TRUE}, \code{test_file} will be executed after saving the recording.}
}
\description{
Once a recording is completed, it will create or append a new
\pkg{shinytest2} test to the \pkg{testthat} \code{test_file}.
}
\section{Uploading files}{


Files that are uploaded to your Shiny app must be located somewhere within
the \code{tests/testthat} subdirectory or available via \code{system.file()}.

Files that are uploaded during recording that do not have a valid path will
have a warning inserted into the code. Please fix the file path by moving the
file to the \code{tests/testthat} subdirectory or by using \code{system.file()}. After
fixing the path, remove the line of warning code.
}

\examples{
\dontrun{
record_test("path/to/app")
}
}
\seealso{
\code{\link[=test_app]{test_app()}}
}
