% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{Validator}
\alias{Validator}
\title{Class representing a Validator.}
\description{
Validators are used to validate input fields in a ShinyForm.
Validators are to be used with the validatedInput function.
A single input field can have several validators.
}
\details{
Package shinyreformss defines a set of commonly used pre-defined
Validators. These include:
\describe{
 \item{ValidatorMinLength(minLength):}{Will fail if string is shorter than minLength.}
 \item{ValidatorMaxLength(maxLength):}{Will fail if string is longer than maxLength.}
 \item{ValidatorNonEmpty():}{Will fail if string is empty.}
}
}
\examples{
if(interactive()){
Validator(function(value) {
  ...
}, "Validation failed!")
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{test}}{Function returning a boolean value which will be used
to validate input.}

\item{\code{failMessage}}{Error message to display when validation fails.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Validator$new()}}
\item \href{#method-check}{\code{Validator$check()}}
\item \href{#method-clone}{\code{Validator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a Validator object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Validator$new(test, failMessage)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{test}}{A function to test the input. Should
take a single value as input and return a boolean.}

\item{\code{failMessage}}{A fail message to be displayed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check"></a>}}
\if{latex}{\out{\hypertarget{method-check}{}}}
\subsection{Method \code{check()}}{
Performs a check on the input.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Validator$check(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Input value to be tested.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the check passes, FALSE if otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Validator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
