% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-material-spinner.R
\name{material_spinner_show}
\alias{material_spinner_show}
\alias{material_spinner_hide}
\title{Create a material preloader (spinner)}
\usage{
material_spinner_show(session, output_id)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{output_id}{The output id for which the spinner will be a placeholder for.}
}
\description{
Display a preloader (spinner) while server is busy.
}
\examples{
if(interactive()){
  library(shiny)
  library(shinymaterial)
  
  ui <- material_page(
    title = "Spinner Example",
    numericInput(inputId = "n", label = "", value = 10),
    plotOutput("n_plot")
 )
  
  server <- function(input, output, session) {
    
    output$n_plot <- renderPlot({
    
      #--- Show the spinner ---#
      material_spinner_show(session, "n_plot")
      
      #--- Simulate calculation step ---#
      Sys.sleep(time = 5)
      
      #--- Hide the spinner ---#
      material_spinner_hide(session, "n_plot")
      
      plot(1:input$n)
    })
    
  }
  shinyApp(ui = ui, server = server)
}
}
