% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxes.R
\name{flipBox}
\alias{flipBox}
\alias{updateFlipBox}
\title{A flipBox based on the W3C example}
\usage{
flipBox(id, front, back, trigger = c("click", "hover"), width = 6)

updateFlipBox(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{id}{\link{flipBox} id.}

\item{front}{ui for the front of the flip box}

\item{back}{ui for the back of the flip box}

\item{trigger}{How to trigger rotate effect. Either click or hover. Default to click.}

\item{width}{flipbox width. Between 1 and 12.}

\item{session}{Shiny session object.}
}
\description{
\link{flipBox} creates a box that flips from back to front and inversely

\link{updateFlipBox} programmatically toggles a \link{flipBox} from the
server.
}
\details{
To access the state of the flipbox use the input alias \code{input$<id>}.
For example, if your flipBox's id is myawesomeflipbox, you can access its state via
\code{input$myawesomeflipbox} where TRUE corresponds to the front, FALSE to the back.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
      fluidRow(
        column(
          width = 6,
          uiOutput("active_side"), 
          flipBox(
            id = "myflipbox", 
            trigger = "hover",
            width = 12,
            front = div(
              class = "text-center",
              h1("Flip on hover"),
              img(
                src = "https://image.flaticon.com/icons/svg/149/149076.svg",
                height = "300px",
                width = "100\%"
              )
            ),
            back = div(
              class = "text-center",
              height = "300px",
              width = "100\%",
              h1("Flip on hover"),
              p("More information....")
            )
          )
        ),
        column(
          width = 6,
          uiOutput("active_side_2"),
          flipBox(
            id = "myflipbox2",
            width = 12,
            front = div(
              class = "text-center",
              h1("Flip on click"),
              img(
                src = "https://image.flaticon.com/icons/svg/149/149076.svg",
                height = "300px",
                width = "100\%"
              )
            ),
            back = div(
              class = "text-center",
              height = "300px",
              width = "100\%",
              h1("Flip on click"),
              p("More information....")
            )
          )
        )
      )
    )
  ),
  
  server = function(input, output, session) {
    output$active_side <- renderUI({
      side <- if (input$myflipbox) "front" else "back"
      dashboardBadge(side, color = "blue")
    })
    
    output$active_side_2<- renderUI({
      side <- if (input$myflipbox2) "front" else "back"
      dashboardBadge(side, color = "blue")
    })
  }
 )
}
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 shinyApp(
   ui = dashboardPage(
     dashboardHeader(),
     dashboardSidebar(),
     dashboardBody(
       actionButton("toggle", "Toggle flip box"),
       uiOutput("active_side"), 
       flipBox(
         id = "myflipbox",
         front = div(
           class = "text-center",
           img(
             src = "https://image.flaticon.com/icons/svg/149/149076.svg",
             height = "300px",
             width = "100\%"
           )
         ),
         back = div(
           class = "text-center",
           height = "300px",
           width = "100\%",
           h1("Details...."),
           p("More information....")
         )
       )
     )
   ),
   
   server = function(input, output, session) {
    output$active_side <- renderUI({
     side <- if (input$myflipbox) "front" else "back"
     dashboardBadge(side, color = "blue")
    })
    
    observeEvent(input$toggle, {
     updateFlipBox("myflipbox")
    })
   }
 )
}
}
