% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardPage.R
\name{dashboardPage}
\alias{dashboardPage}
\title{Dashboard Page with a right sidebar}
\usage{
dashboardPage(
  header,
  sidebar,
  body,
  controlbar = NULL,
  footer = NULL,
  title = NULL,
  skin = c("blue", "blue-light", "black", "black-light", "purple", "purple-light",
    "green", "green-light", "red", "red-light", "yellow", "yellow-light", "midnight"),
  freshTheme = NULL,
  preloader = NULL,
  md = FALSE,
  options = NULL,
  scrollToTop = FALSE
)
}
\arguments{
\item{header}{A header created by \code{\link{dashboardHeader}}.}

\item{sidebar}{A sidebar created by \code{\link{dashboardSidebar}}.}

\item{body}{A body created by \code{\link[shinydashboard]{dashboardBody}}.}

\item{controlbar}{A right sidebar created by \link{dashboardControlbar}. NULL by
default.}

\item{footer}{A footer created by \link{dashboardFooter}.}

\item{title}{A title to display in the browser's title bar. If no value is
provided, it will try to extract the title from the
\code{dashboardHeaderPlus}.}

\item{skin}{A color theme. See \url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.
If the skin is light, the sidebar will have a light background. Not compatible with freshTheme.}

\item{freshTheme}{A skin powered by the fresh package. Not compatible with skin.
See \url{https://dreamrs.github.io/fresh/articles/vars-shinydashboard.html}.}

\item{preloader}{shinydashboardPlus uses waiter (see \url{https://waiter.john-coene.com/#/}).
Pass a list like \code{list(html = spin_1(), color = "#333e48")}.
\code{waiter} expects to provide a sub-list to configure \link[waiter]{waiter_show_on_load} (refer to
the package help for all styles). \code{duration} defines the loader timeout.}

\item{md}{Whether to enable material design. Experimental...}

\item{options}{Extra option to overwrite the vanilla AdminLTE configuration. See 
\url{https://adminlte.io/themes/AdminLTE/documentation/index.html#adminlte-options}.
Expect a list.}

\item{scrollToTop}{Whether to display a scroll to top button whenever the page height is too large.
Default to FALSE.}
}
\description{
This creates a dashboard page for use in a Shiny app.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 library(fresh)
 
 shinyApp(
   ui = dashboardPage(
     freshTheme = create_theme(
      adminlte_color(
        light_blue = "#55e7ff",
        blue = "#2011a2",
        navy = "#201148",
        red = "#ff34b3"
      ),
      adminlte_sidebar(
        dark_bg = "#D8DEE9",
        dark_hover_bg = "#81A1C1",
        dark_color = "#2E3440"
      ),
      adminlte_global(
        content_bg = "#FFF",
        box_bg = "#D8DEE9", 
        info_box_bg = "#D8DEE9"
      )
     ),
     options = list(sidebarExpandOnHover = TRUE),
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(
      box(background = "red"),
      box(background = "blue"),
      box(background = "navy")
     ),
     controlbar = dashboardControlbar(),
     title = "DashboardPage"
   ),
   server = function(input, output) { }
 )
}
}
\seealso{
\code{\link{dashboardHeader}}, \code{\link{dashboardSidebar}},
  \code{\link[shinydashboard]{dashboardBody}}.
}
