% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptionBlock.R
\name{descriptionBlock}
\alias{descriptionBlock}
\title{AdminLTE2 description block}
\usage{
descriptionBlock(number = NULL, number_color = NULL, number_icon = NULL,
  header = NULL, text = NULL, right_border = TRUE,
  margin_bottom = FALSE)
}
\arguments{
\item{number}{any number.}

\item{number_color}{number color: see here for a list of valid colors \url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.}

\item{number_icon}{number icon, if any. Should be written like "fa fa-times".}

\item{header}{bold text.}

\item{text}{additional text.}

\item{right_border}{TRUE by default. Whether to display a right border to
separate two blocks. The last block on the right should not have a right border.}

\item{margin_bottom}{FALSE by default. Set it to TRUE when the
descriptionBlock is used in a boxPad context.}
}
\description{
Create a description block, perfect for writing statistics
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      solidHeader = FALSE,
      title = "Status summary",
      background = NULL,
      width = 4,
      status = "danger",
      footer = fluidRow(
        column(
          width = 6,
          descriptionBlock(
            number = "17\%", 
            number_color = "green", 
            number_icon = "fa fa-caret-up",
            header = "$35,210.43", 
            text = "TOTAL REVENUE", 
            right_border = TRUE,
            margin_bottom = FALSE
          )
        ),
        column(
          width = 6,
          descriptionBlock(
            number = "18\%", 
            number_color = "red", 
            number_icon = "fa fa-caret-down",
            header = "1200", 
            text = "GOAL COMPLETION", 
            right_border = FALSE,
            margin_bottom = FALSE
          )
        )
      )
     )
    ),
    title = "Description Blocks"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
