% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WinBox.R
\name{wbControls}
\alias{wbControls}
\title{WinBox controls}
\usage{
wbControls(
  animation = TRUE,
  shadow = TRUE,
  header = TRUE,
  min = TRUE,
  max = TRUE,
  full = FALSE,
  close = TRUE,
  resize = TRUE,
  move = TRUE
)
}
\arguments{
\item{animation}{If \code{FALSE}, disables the windows transition animation.}

\item{shadow}{If \code{FALSE}, disables the windows drop shadow.}

\item{header}{If \code{FALSE}, hide the window header incl. title and toolbar.}

\item{min}{If \code{FALSE}, hide the minimize icon.}

\item{max}{If \code{FALSE}, hide the maximize icon.}

\item{full}{If \code{FALSE}, hide the fullscreen icon.}

\item{close}{If \code{FALSE}, hide the close icon.}

\item{resize}{If \code{FALSE}, disables the window resizing capability.}

\item{move}{If \code{FALSE}, disables the window moving capability.}
}
\value{
A \code{list} of controls to use in \code{\link[=WinBox]{WinBox()}}.
}
\description{
WinBox controls
}
\examples{

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  html_dependency_winbox(),
  actionButton(inputId = "show", label = "Show WinBox")
)

server <- function(input, output, session) {

  observeEvent(input$show, {
    WinBox(
      title = "Custom controls",
      ui = tagList(
        tags$h2("Hello from WinBox!"),
        "Text content of winbox."
      ),
      controls = wbControls(
        min = FALSE,
        max = FALSE,
        resize = FALSE
      )
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
