% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7SmartSelect}
\alias{f7SmartSelect}
\title{Create a Framework7 smart select}
\usage{
f7SmartSelect(
  inputId,
  label,
  choices,
  selected = NULL,
  type = c("sheet", "popup", "popover"),
  smart = TRUE,
  multiple = FALSE
)
}
\arguments{
\item{inputId}{Select input id.}

\item{label}{Select input label.}

\item{choices}{Select input choices.}

\item{selected}{Default selected item.}

\item{type}{Smart select type: either \code{c("sheet", "popup", "popover")}.
Note that the search bar is only available when the type is popup.}

\item{smart}{Whether to enable the search bar. TRUE by default.}

\item{multiple}{Whether to allow multiple values. FALSE by default.}
}
\description{
It is nicer than the classic \link{f7Select}
and allows for search.
}
\examples{
if (interactive()) {
library(shiny)
library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7SmartSelect"),
       f7SmartSelect(
         inputId = "variable",
         label = "Choose a variable:",
         selected = "drat",
         choices = colnames(mtcars)[-1],
         type = "popup"
       ),
       tableOutput("data")
     )
   ),
   server = function(input, output) {
     output$data <- renderTable({
       mtcars[, c("mpg", input$variable), drop = FALSE]
     }, rownames = TRUE)
   }
 )
}
}
