% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyML_regression.R
\name{shinyML_regression}
\alias{shinyML_regression}
\title{Implement a shiny web app to compare h2o and Spark supervised machine learning models for regression tasks}
\usage{
shinyML_regression(
  data = data,
  y,
  framework = "h2o",
  share_app = FALSE,
  port = NULL
)
}
\arguments{
\item{data}{dataset containing one or more explanatory variables and one numeric variable to forecast.
The dataset must be a data.frame or a data.table and can contain time-based column on Date or POSIXct format}

\item{y}{the numerical output variable to forecast (must correspond to one data column)}

\item{framework}{the machine learning framework chosen to train and test models (either h2o or Spark). h2o by default}

\item{share_app}{a logical value indicating whether the app must be shared on local LAN}

\item{port}{a four-digit number corresponding to the port the application should listen to. This parameter is necessary only  if share_app option is set to TRUE}
}
\description{
This function creates in one line of code a shareable web app to compare supervised regression model performances
}
\examples{
\dontrun{
library(shinyML)
# Classical regression analysis 
shinyML_regression(data = iris,y = "Petal.Width",framework = "h2o")

# Time series analysis
longley2 <- longley \%>\% mutate(Year = as.Date(as.character(Year),format = "\%Y"))
shinyML_regression(data = longley2,y = "Population",framework = "h2o")
}
}
\author{
Jean Bertin, \email{jean.bertin@mines-paris.org}
}
