% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showFeedback.R
\name{showFeedback}
\alias{showFeedback}
\alias{showFeedbackWarning}
\alias{showFeedbackDanger}
\alias{showFeedbackSuccess}
\title{showFeedback}
\usage{
showFeedback(
  inputId,
  text = NULL,
  color = NULL,
  icon = NULL,
  session = shiny::getDefaultReactiveDomain()
)

showFeedbackWarning(
  inputId,
  text = "Ye be warned",
  color = "#F89406",
  icon = shiny::icon("warning-sign", lib = "glyphicon"),
  session = shiny::getDefaultReactiveDomain()
)

showFeedbackDanger(
  inputId,
  text = "Danger, turn back!",
  color = "#d9534f",
  icon = shiny::icon("exclamation-sign", lib = "glyphicon"),
  session = shiny::getDefaultReactiveDomain()
)

showFeedbackSuccess(
  inputId,
  text = NULL,
  color = "#5cb85c",
  icon = shiny::icon("ok", lib = "glyphicon")
)
}
\arguments{
\item{inputId}{the Shiny input's \code{inputId} argument}

\item{text}{text string to display below input}

\item{color}{the color of the feedback}

\item{icon}{an html icon tag}

\item{session}{the \code{shiny} session}
}
\description{
Show feedback next to Shiny inputs.
}
\examples{

## Only run examples in interacive R sessions
if (interactive()) {
  ui <- fluidPage(
    useShinyFeedback(),
    
    numericInput(
      "exampleInput",
      "Show Feedback When < 0",
      value = -5
    )
  )
  
  server <- function(input, output) {
    observeEvent(input$exampleInput, {
      
      if (input$exampleInput < 0) {
      
        showFeedback(
          "exampleInput",
          text = "I am negative",
          color = "#d9534f",
          icon = shiny::icon("exclamation-sign", lib="glyphicon")
        )
      } else {
        hideFeedback("exampleInput")
      }
      
    })
  }
  
  shinyApp(ui, server)
}


## Only run examples in interacive R sessions
if (interactive()) {
  library(shiny)
  
  ui <- fluidPage(
    useShinyFeedback(),
    
    numericInput(
      "exampleInput",
      "Show Feedback When < 0",
      value = -5
    )
  )
  
  server <- function(input, output, session) {
    observeEvent(input$exampleInput, {
      
      if (input$exampleInput < 0) {
        showFeedbackWarning("exampleInput")
      } else {
        hideFeedback("exampleInput")
      }
      
    })
  }
  
  shinyApp(ui, server)
}

}
