% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_event.R
\name{log_event}
\alias{log_event}
\title{Logging an event}
\usage{
log_event(..., name = NULL, type = "EVENT", status = "FIRED",
  params = NULL, event_counter = NULL)
}
\arguments{
\item{...}{Objects that are evaluated, coerced into character string,
collapsed and pasted into log entry body
(or header if \code{name} is \code{NULL}).}

\item{name}{A character string. The name of the event.}

\item{type}{A character string. A type of the event.
Default is \code{"EVENT"}.}

\item{status}{A character string. A status of the event.
Default is \code{"FIRED"}.}

\item{params}{A list of additional named event-specific parameters.
Default is \code{NULL}.}

\item{event_counter}{An integer. The number of the event.
Default is \code{NULL} which will be replaced by the current value
of the counter returned by
the internal getter function \code{get_event_counter}.}
}
\description{
\code{log_event} logs an event into R console, browser JavaScript console,
file, or database
depending on user's settings (see \code{\link{set_logging}}).
}
\examples{
if (interactive()) {
  set_logging()
  shiny::shinyApp(
    ui = shiny::fluidPage(log_init()),
    server = function(input, output) {
      set_logging_session()
      log_event("Event 1")
      log_event("Event 2 body", name = "Event 2")
      log_event("Event 3", type = "NewTYPE")
      log_event("Event 4", status = "EXECUTED")
      log_event("Event 5", event_counter = 123)
    }
  )
}
}
\seealso{
\code{\link{set_logging}} for setting event logging,
  \code{\link{log_init}} for initialize JavaScript logging in shiny app,
  \code{\link{log_params}} for setting scope-specific event parameters,
  \code{\link{read_eventlog}} for reading eventlog from a file or a database.

Other logging events functions: \code{\link{log_message}},
  \code{\link{log_output}}, \code{\link{log_started}},
  \code{\link{log_test}}, \code{\link{log_value}}
}
\concept{logging events functions}
