% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datetimeSliderPicker.R
\name{datetimeSliderPickerInput}
\alias{datetimeSliderPickerInput}
\title{Datetime picker with sliders}
\usage{
datetimeSliderPickerInput(inputId, value = NULL, second = FALSE, save = FALSE)
}
\arguments{
\item{inputId}{the input slot that will be used to access the value}

\item{value}{initial value, either a \code{POSIXct} object, or an object
coercible to a \code{POSIXct} object;
if \code{NULL}, it is set to the current time}

\item{second}{logical, whether to enable the second picker}

\item{save}{logical, whether to enable the 'save' button}
}
\value{
A \code{shiny.tag} object that can be included in a Shiny UI.
}
\description{
A datetime picker for a Shiny UI.
}
\examples{
if(interactive()){
library(shinyDatetimePickers)
library(shiny)

ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      actionButton("setdt", label = as.character(Sys.time()),
                   class = "btn-info")
    ),
    mainPanel()
  )
)

server <- function(input, output, session){

  datetime <- reactiveVal(Sys.time())

  observeEvent(input[["setdt"]], {
    showModal(modalDialog(
      datetimeSliderPickerInput("dtspicker", save = TRUE, value = datetime())
    ))
  })

  observeEvent(input[["dtspicker_save"]], {
    datetime(input[["dtspicker"]])
    removeModal()
    updateActionButton(session, "setdt",
                       label = as.character(input[["dtspicker"]]))
  })

}

shinyApp(ui, server)
}
}
