% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLTApp.R
\name{CLT}
\alias{CLT}
\title{Launch the Central Limit Theorem Shiny application}
\usage{
CLT(n.cores = NULL, mode = "app", user_plan = "cluster")
}
\arguments{
\item{n.cores}{Number of cores to use for calculations. Default value
is NULL, which means that half of the cores will be used with the ceiling
 rounding rule.}

\item{mode}{Change application behaviour when web browser tab or IDE preview
 is closed.
By default this will end the running function and stop the local shinyApp.
Switching to "server" mode will keep the shiny application running in a
background even if all with application is closed.}

\item{user_plan}{Specifies the parallelization strategy to use.
Acceptable values are "cluster" (default), "multicore", or "multisession".}
}
\value{
Runs shinyApp
}
\description{
This function starts a Shiny application that demonstrates examples of
 the Central Limit Theorem.
The app is stored internally within the package and showcases various
 statistical principles through interactive visualizations.
Check more details at vignette("shinyCLT")
}
\examples{
if(interactive()){
  CLT()  # Launch the CLT demonstration app
}
}
