% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-input.R
\name{updateTextInput}
\alias{updateTextInput}
\title{Change the value of a text input on the client}
\usage{
updateTextInput(
  session = getDefaultReactiveDomain(),
  inputId,
  label = NULL,
  value = NULL,
  placeholder = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}. Default is \code{getDefaultReactiveDomain()}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{Initial value.}

\item{placeholder}{A character string giving the user a hint as to what can
be entered into the control. Internet Explorer 8 and 9 do not support this
option.}
}
\description{
Change the value of a text input on the client
}
\details{
The input updater functions send a message to the client, telling it to
change the settings of an input object. The messages are collected and sent
after all the observers (including outputs) have finished running.

The syntax of these functions is similar to the functions that created the
inputs in the first place. For example, \code{\link{numericInput}()} and
\code{updateNumericInput()} take a similar set of arguments.

Any arguments with NULL values will be ignored; they will not result in any
changes to the input object on the client.

For \code{\link{radioButtons}()}, \code{\link{checkboxGroupInput}()} and
\code{\link{selectInput}()}, the set of choices can be cleared by using
\code{choices=character(0)}. Similarly, for these inputs, the selected item
can be cleared by using \code{selected=character(0)}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  sliderInput("controller", "Controller", 0, 20, 10),
  textInput("inText", "Input text"),
  textInput("inText2", "Input text 2")
)

server <- function(input, output, session) {
  observe({
    # We'll use the input$controller variable multiple times, so save it as x
    # for convenience.
    x <- input$controller

    # This will change the value of input$inText, based on x
    updateTextInput(session, "inText", value = paste("New text", x))

    # Can also set the label, this time for input$inText2
    updateTextInput(session, "inText2",
      label = paste("New label", x),
      value = paste("New text", x))
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link[=textInput]{textInput()}}
}
