% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert-tab.R
\name{insertTab}
\alias{insertTab}
\alias{prependTab}
\alias{appendTab}
\alias{removeTab}
\title{Dynamically insert/remove a tabPanel}
\usage{
insertTab(inputId, tab, target, position = c("before", "after"),
  select = FALSE, session = getDefaultReactiveDomain())

prependTab(inputId, tab, select = FALSE, menuName = NULL,
  session = getDefaultReactiveDomain())

appendTab(inputId, tab, select = FALSE, menuName = NULL,
  session = getDefaultReactiveDomain())

removeTab(inputId, target, session = getDefaultReactiveDomain())
}
\arguments{
\item{inputId}{The \code{id} of the \code{tabsetPanel} (or
\code{navlistPanel} or \code{navbarPage}) into which \code{tab} will
be inserted/removed.}

\item{tab}{The item to be added (must be created with \code{tabPanel},
or with \code{navbarMenu}).}

\item{target}{If inserting: the \code{value} of an existing
\code{tabPanel}, next to which \code{tab} will be added.
If removing: the \code{value} of the \code{tabPanel} that
you want to remove. See Details if you want to insert next to/remove
an entire \code{navbarMenu} instead.}

\item{position}{Should \code{tab} be added before or after the
\code{target} tab?}

\item{select}{Should \code{tab} be selected upon being inserted?}

\item{session}{The shiny session within which to call this function.}

\item{menuName}{This argument should only be used when you want to
prepend (or append) \code{tab} to the beginning (or end) of an
existing \code{\link{navbarMenu}} (which must itself be part of
an existing \code{\link{navbarPage}}). In this case, this argument
should be the \code{menuName} that you gave your \code{navbarMenu}
when you first created it (by default, this is equal to the value
of the \code{title} argument). Note that you still need to set the
\code{inputId} argument to whatever the \code{id} of the parent
\code{navbarPage} is. If \code{menuName} is left as \code{NULL},
\code{tab} will be prepended (or appended) to whatever
\code{inputId} is.}
}
\description{
Dynamically insert or remove a \code{\link{tabPanel}} (or a
\code{\link{navbarMenu}}) from an existing \code{\link{tabsetPanel}},
\code{\link{navlistPanel}} or \code{\link{navbarPage}}.
}
\details{
When you want to insert a new tab before or after an existing tab, you
should use \code{insertTab}. When you want to prepend a tab (i.e. add a
tab to the beginning of the \code{tabsetPanel}), use \code{prependTab}.
When you want to append a tab (i.e. add a tab to the end of the
\code{tabsetPanel}), use \code{appendTab}.

For \code{navbarPage}, you can insert/remove conventional
\code{tabPanel}s (whether at the top level or nested inside a
\code{navbarMenu}), as well as an entire \code{\link{navbarMenu}}.
For the latter case, \code{target} should be the \code{menuName} that
you gave your \code{navbarMenu} when you first created it (by default,
this is equal to the value of the \code{title} argument).
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {

# example app for inserting/removing a tab
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      actionButton("add", "Add 'Dynamic' tab"),
      actionButton("remove", "Remove 'Foo' tab")
    ),
    mainPanel(
      tabsetPanel(id = "tabs",
        tabPanel("Hello", "This is the hello tab"),
        tabPanel("Foo", "This is the foo tab"),
        tabPanel("Bar", "This is the bar tab")
      )
    )
  )
)
server <- function(input, output, session) {
  observeEvent(input$add, {
    insertTab(inputId = "tabs",
      tabPanel("Dynamic", "This a dynamically-added tab"),
      target = "Bar"
    )
  })
  observeEvent(input$remove, {
    removeTab(inputId = "tabs", target = "Foo")
  })
}

shinyApp(ui, server)


# example app for prepending/appending a navbarMenu
ui <- navbarPage("Navbar page", id = "tabs",
  tabPanel("Home",
    actionButton("prepend", "Prepend a navbarMenu"),
    actionButton("append", "Append a navbarMenu")
  )
)
server <- function(input, output, session) {
  observeEvent(input$prepend, {
    id <- paste0("Dropdown", input$prepend, "p")
    prependTab(inputId = "tabs",
      navbarMenu(id,
        tabPanel("Drop1", paste("Drop1 page from", id)),
        tabPanel("Drop2", paste("Drop2 page from", id)),
        "------",
        "Header",
        tabPanel("Drop3", paste("Drop3 page from", id))
      )
    )
  })
  observeEvent(input$append, {
    id <- paste0("Dropdown", input$append, "a")
    appendTab(inputId = "tabs",
      navbarMenu(id,
        tabPanel("Drop1", paste("Drop1 page from", id)),
        tabPanel("Drop2", paste("Drop2 page from", id)),
        "------",
        "Header",
        tabPanel("Drop3", paste("Drop3 page from", id))
      )
    )
  })
}

shinyApp(ui, server)

}
}
\seealso{
\code{\link{showTab}}
}
