% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{onFlush}
\alias{onFlush}
\alias{onFlushed}
\alias{onSessionEnded}
\title{Add callbacks for Shiny session events}
\usage{
onFlush(fun, once = TRUE, session = getDefaultReactiveDomain())

onFlushed(fun, once = TRUE, session = getDefaultReactiveDomain())

onSessionEnded(fun, session = getDefaultReactiveDomain())
}
\arguments{
\item{fun}{A callback function.}

\item{once}{Should the function be run once, and then cleared, or should it
re-run each time the event occurs. (Only for \code{onFlush} and
\code{onFlushed}.)}

\item{session}{A shiny session object.}
}
\description{
These functions are for registering callbacks on Shiny session events.
\code{onFlush} registers a function that will be called before Shiny flushes
the reactive system. \code{onFlushed} registers a function that will be
called after Shiny flushes the reactive system. \code{onSessionEnded}
registers a function to be called after the client has disconnected.
}
\details{
These functions should be called within the application's server function.

All of these functions return a function which can be called with no
arguments to cancel the registration.
}
