% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageutils.R
\name{plotPNG}
\alias{plotPNG}
\title{Run a plotting function and save the output as a PNG}
\usage{
plotPNG(func, filename = tempfile(fileext = ".png"), width = 400,
  height = 400, res = 72, ...)
}
\arguments{
\item{func}{A function that generates a plot.}

\item{filename}{The name of the output file. Defaults to a temp file with
extension \code{.png}.}

\item{width}{Width in pixels.}

\item{height}{Height in pixels.}

\item{res}{Resolution in pixels per inch. This value is passed to
\code{\link[grDevices]{png}}. Note that this affects the resolution of PNG rendering in
R; it won't change the actual ppi of the browser.}

\item{...}{Arguments to be passed through to \code{\link[grDevices]{png}}.
These can be used to set the width, height, background color, etc.}
}
\description{
This function returns the name of the PNG file that it generates. In
essence, it calls \code{png()}, then \code{func()}, then \code{dev.off()}.
So \code{func} must be a function that will generate a plot when used this
way.
}
\details{
For output, it will try to use the following devices, in this order:
quartz (via \code{\link[grDevices]{png}}), then \code{\link[Cairo]{CairoPNG}},
and finally \code{\link[grDevices]{png}}. This is in order of quality of
output. Notably, plain \code{png} output on Linux and Windows may not
antialias some point shapes, resulting in poor quality output.

In some cases, \code{Cairo()} provides output that looks worse than
\code{png()}. To disable Cairo output for an app, use
\code{options(shiny.usecairo=FALSE)}.
}

