% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/input-radiobuttons.R
\name{radioButtons}
\alias{radioButtons}
\title{Create radio buttons}
\usage{
radioButtons(inputId, label, choices, selected = NULL, inline = FALSE,
  width = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{List of values to select from (if elements of the list are
named then that name rather than the value is displayed to the user)}

\item{selected}{The initially selected value (if not specified then
defaults to the first value)}

\item{inline}{If \code{TRUE}, render the choices inline (i.e. horizontally)}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link{validateCssUnit}}.}
}
\value{
A set of radio buttons that can be added to a UI definition.
}
\description{
Create a set of radio buttons used to select an item from a list.
}
\details{
If you need to represent a "None selected" state, it's possible to default
the radio buttons to have no options selected by using
\code{selected = character(0)}. However, this is not recommended, as it gives
the user no way to return to that state once they've made a selection.
Instead, consider having the first of your choices be \code{c("None selected"
= "")}.
}
\examples{
radioButtons("dist", "Distribution type:",
             c("Normal" = "norm",
               "Uniform" = "unif",
               "Log-normal" = "lnorm",
               "Exponential" = "exp"))
}
\seealso{
\code{\link{updateRadioButtons}}

Other input.elements: \code{\link{actionButton}},
  \code{\link{actionLink}}; \code{\link{animationOptions}},
  \code{\link{sliderInput}};
  \code{\link{checkboxGroupInput}};
  \code{\link{checkboxInput}}; \code{\link{dateInput}};
  \code{\link{dateRangeInput}}; \code{\link{fileInput}};
  \code{\link{numericInput}}; \code{\link{passwordInput}};
  \code{\link{selectInput}}, \code{\link{selectizeInput}};
  \code{\link{submitButton}}; \code{\link{textInput}}
}

