% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jdate.R, R/jdatetime.R
\name{shide-coercion}
\alias{shide-coercion}
\alias{vec_ptype2.jdate}
\alias{vec_ptype2.jdatetime}
\title{Coercion}
\usage{
\method{vec_ptype2}{jdate}(x, y, ..., x_arg = "", y_arg = "")

\method{vec_ptype2}{jdatetime}(x, y, ..., x_arg = "", y_arg = "")
}
\arguments{
\item{x, y}{Vector types.}

\item{...}{These dots are for future extensions and must be empty.}

\item{x_arg, y_arg}{Argument names for \code{x} and \code{y}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[vctrs:stop_incompatible_type]{stop_incompatible_type()}}).}
}
\value{
An object prototype if x and y can be safely coerced to the same prototype;
otherwise it returns an error. See details for more information on
coercion hierarchy for \code{jdate} and \code{jdatetime}.
}
\description{
Double dispatch methods to support \code{\link[vctrs:vec_ptype2]{vctrs::vec_ptype2()}}.
}
\details{
Coercion rules for \code{jdate} and \code{jdatetime}:
\itemize{
\item Combining a \code{jdate} and \code{jdatetime} yields a \code{jdatetime}.
\item When combining two \code{jdatetime} objects, the timezone is taken from the first non-local timezone.
}
}
\examples{
# jdate and jdatetime are compatible
c(jdate(), jdatetime(), jdatetime(tzone = "UTC"))
# jdate and Date are incompatible
try(c(jdate(), as.Date(NULL)))
}
