% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomize_raster.R
\name{randomize_raster}
\alias{randomize_raster}
\title{randomize_raster}
\usage{
randomize_raster(
  raster,
  n_random = 1,
  directions = 4,
  return_input = TRUE,
  simplify = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{raster}{SpatRaster with discrete habitat classes.}

\item{n_random}{Integer with number of randomizations.}

\item{directions}{Interger with cells neighbourhood rule: 4 (rook's case), 8 (queen's case).}

\item{return_input}{Logical if the original input data is returned.}

\item{simplify}{Logical if only the raster will be returned if \code{n_random = 1}
and \code{return_input = FALSE}.}

\item{verbose}{Logical if progress report is printed.}
}
\value{
rd_ras
}
\description{
Randomized-habitats procedure
}
\details{
The function randomizes a habitat map with discrete classes (as SpatRaster) as proposed
by Harms et al. (2001) as “randomized-habitats procedure”. The algorithm starts with an
empty habitat map and starts to assign random neighbouring cells to each habitat
(in increasing order of abundance in observed map). We modified the procedure
slightly by increasing a probability to jump to a non-neighbouring cell as the
current patch becomes larger.

In case the SpatRaster contains NA cells, this needs to be reflected in the observation
window of the point pattern as well (i.e., no point locations possible in these areas).
}
\examples{
\dontrun{
landscape_classified <- classify_habitats(terra::rast(landscape), n = 5, style = "fisher")
landscape_random <- randomize_raster(landscape_classified, n_random = 19)
}

}
\references{
Harms, K.E., Condit, R., Hubbell, S.P., Foster, R.B., 2001. Habitat associations of
trees and shrubs in a 50-ha neotropical forest plot. Journal of Ecology 89, 947–959.
<https://doi.org/10.1111/j.1365-2745.2001.00615.x>
}
\seealso{
\code{\link{translate_raster}}
}
