% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miniSim.R
\name{miniSim}
\alias{miniSim}
\title{Mini Simulator}
\usage{
miniSim(sampleSize = 50, clusterSize = 4, responseCor = 0.4,
  groupSparsity = "No Sparsity", xVariance = 1, covariateCor = 0.4,
  intercept = 1, SNR = 10, techniques = c("SEE", "BiSEE", "GSEE",
  "HiSEE"), stepSize = 0.125, maxNumSteps = 400, reps = 200)
}
\arguments{
\item{sampleSize}{Number of clusters to be used in each replicate.}

\item{clusterSize}{Size of each cluster.}

\item{responseCor}{Correlation parameter for response.}

\item{groupSparsity}{String specifying within group sparsity level;
currently takes values 'No Sparsity', 'Mod Sparsity', or
'High Sparsity'.}

\item{xVariance}{Scalar value indicating marginal variance of the
covariates.}

\item{covariateCor}{Correlation parameter used for within group correlation.}

\item{intercept}{Scalar value indicating the true intercept value.}

\item{SNR}{Optional scalar value that allows fixing the signal
to noise ratio as defined as the ratio of the variance in the
linear predictor to the variance of the response conditioned on the
covariates.}

\item{techniques}{Vector of all techniques to be used for comparison;
default value of \code{c("SEE", "BiSEE", "GSEE", "HiSEE")} currently contains
all possible values.}

\item{stepSize}{Stepsize to be used in stagewise techniques.}

\item{maxNumSteps}{Maximum number of steps to be taken by stagewise
techniques.}

\item{reps}{Number of replicates to be used for simulation.}
}
\value{
Simulation results.
}
\description{
Function to do a miniature simulation testing the various grouped stagewise
techniques.
}
\details{
Function is currently under development and is thus not exported. Function
is intended to allow for simple simulation implementation to explore
the provided stagewise regression functions.
}
\note{
Currently still under development, so not exported.
}
\author{
Gregory Vaughan
}
\keyword{internal}
