% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_path.R
\name{plot_path}
\alias{plot_path}
\title{Coefficient path of a sparse-group boosting model}
\usage{
plot_path(sgb_model, max_char_length = 5, base_size = 8)
}
\arguments{
\item{sgb_model}{Model of type \code{mboost} to be used.}

\item{max_char_length}{The maximum character length of a predictor to be printed.
Default is 5. For long variable names one may adjust this number.}

\item{base_size}{The \code{base_size} argument to be passed to the \code{ggplot2} theme
\link[ggplot2:ggtheme]{ggplot2::theme_bw} to be used to control the overall size of the figure.
Default value is 8.}
}
\value{
\code{ggplot2} object mapping the effect sizes and variable importance.
}
\description{
Shows how the effect sizes change throughout the boosting iterations
in a sparse-group boosting model. Works also for a regular mboost models.
Color indicates the selection of group or individual variables within a boosting iteration.
}
\examples{
library(mboost)
library(dplyr)
set.seed(1)
df <- data.frame(
  x1 = rnorm(100), x2 = rnorm(100), x3 = rnorm(100),
  x4 = rnorm(100), x5 = runif(100)
)
df <- df \%>\%
  mutate_all(function(x) {
    as.numeric(scale(x))
  })
df$y <- df$x1 + df$x4 + df$x5
group_df <- data.frame(
  group_name = c(1, 1, 1, 2, 2),
  var_name = c("x1", "x2", "x3", "x4", "x5")
)

sgb_formula <- as.formula(create_formula(alpha = 0.4, group_df = group_df))
sgb_model <- mboost(formula = sgb_formula, data = df)
plot_path(sgb_model)
}
\seealso{
\code{\link[=get_coef_path]{get_coef_path()}} which this function uses.
}
