% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{sf_multipoint}
\alias{sf_multipoint}
\title{sf MULTIPOINT}
\usage{
sf_multipoint(obj, x = NULL, y = NULL, z = NULL, m = NULL,
  multipoint_id = NULL)
}
\arguments{
\item{obj}{sorted matrix or data.frame}

\item{x}{x geometry column}

\item{y}{y geometry column}

\item{z}{z geometry column}

\item{m}{m geometry column}

\item{multipoint_id}{column of ids for multipoints}
}
\value{
\code{sf} object of MULTIPOINT geometries
}
\description{
constructs sf of MULTIPOINT objects
}
\section{notes}{

sfheaders functions do not perform any validity checks on the geometries.
Nor do they set Coordinate Reference Systems, EPSG, PROJ4 or precision attributes.

The data.frame and matrices you send into the sfheader functions must be ordered.
}

\examples{

x <- matrix( c(1:4), ncol = 2 )
sf_multipoint( x )

x <- data.frame( id = 1:2, x = 1:2, y = 2:1 )
sf_multipoint( x )
sf_multipoint( x, x = "x", y = "y" )
sf_multipoint( x, x = "y", y = "x" )
sf_multipoint( x, multipoint_id = "id", x = "x", y = "y")

}
