% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operation_setpower.R
\name{setpower}
\alias{setpower}
\alias{^.Set}
\title{Power of a Set}
\usage{
setpower(x, power, simplify = FALSE, nest = FALSE)

\method{^}{Set}(x, power)
}
\arguments{
\item{x}{Set}

\item{power}{power to raise set to, if \code{"n"} then a variable dimension set is created,
see examples.`}

\item{simplify}{logical, if \code{TRUE} returns the result in its simplest (unwrapped) form, usually
a \code{Set}, otherwise an \code{ExponentSet}.}

\item{nest}{logical, if \code{FALSE} (default) returns the n-ary cartesian product, otherwise returns
the cartesian product applied n times.
\link{Set}s. See details and examples.}
}
\value{
An R6 object of class \code{Set} or \code{ExponentSet} inheriting from \code{ProductSet}.
}
\description{
A convenience wrapper for the n-ary cartesian product of a \code{Set} by itself,
possibly multiple times.
}
\details{
See the details of \link{setproduct} for a longer discussion on the use of the \code{nest}
argument, in particular with regards to n-ary cartesian products vs. 'standard' cartesian
products.
}
\examples{
# Power of a Set
setpower(Set$new(1, 2), 3, simplify = FALSE)
setpower(Set$new(1, 2), 3, simplify = TRUE)
Set$new(1, 2)^3

# Power of an interval
Interval$new(2, 5)^5
Reals$new()^3

# Use tuples for contains
(PosNaturals$new()^3)$contains(Tuple$new(1, 2, 3))

# Power of ConditionalSet is meaningless
ConditionalSet$new(function(x) TRUE)^2

# Power of FuzzySet
FuzzySet$new(1, 0.1, 2, 0.5)^2

# Variable length
x <- Interval$new(0, 1)^"n"
x$contains(Tuple$new(0))
x$contains(Tuple$new(0, 1))
x$contains(Tuple$new(0, 1, 0, 0, 1, 1, 0))
x$contains(list(Tuple$new(0, 2), Tuple$new(1, 1)))

}
\seealso{
Other operators: 
\code{\link{powerset}()},
\code{\link{setcomplement}()},
\code{\link{setintersect}()},
\code{\link{setproduct}()},
\code{\link{setsymdiff}()},
\code{\link{setunion}()}
}
\concept{operators}
