% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_Tuple.R
\name{Tuple}
\alias{Tuple}
\title{Mathematical Tuple}
\description{
A general Tuple object for mathematical tuples, inheriting from \code{Set}.
}
\details{
Tuples are similar to sets, except that they drop the constraint for elements to be unique, and
ordering in a tuple does matter. Tuples are useful for methods including \verb{$contains} that may
require non-unique elements. They are also the return type of the product of sets. See examples.
}
\examples{
# Tuple of integers
Tuple$new(1:5)

# Tuple of multiple types
Tuple$new("a", 5, Set$new(1), Tuple$new(2))

# Each Tuple has properties and traits
t <- Tuple$new(1, 2, 3)
t$traits
t$properties

# Elements can be duplicated
Tuple$new(2, 2) != Tuple$new(2)

# Ordering does matter
Tuple$new(1, 2) != Tuple$new(2, 1)

## ------------------------------------------------
## Method `Tuple$equals`
## ------------------------------------------------

Tuple$new(1,2) ==  Tuple$new(1,2)
Tuple$new(1,2) != Tuple$new(1,2)
Tuple$new(1,1) != Set$new(1,1)

## ------------------------------------------------
## Method `Tuple$isSubset`
## ------------------------------------------------

Tuple$new(1,2,3) < Tuple$new(1,2,3,4)
Tuple$new(1,3,2) < Tuple$new(1,2,3,4)
}
\seealso{
Other sets: 
\code{\link{ConditionalSet}},
\code{\link{FuzzySet}},
\code{\link{FuzzyTuple}},
\code{\link{Interval}},
\code{\link{LogicalSet}},
\code{\link{Set}},
\code{\link{UniversalSet}}
}
\concept{sets}
\section{Super class}{
\code{\link[set6:Set]{set6::Set}} -> \code{Tuple}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-equals}{\code{Tuple$equals()}}
\item \href{#method-isSubset}{\code{Tuple$isSubset()}}
\item \href{#method-clone}{\code{Tuple$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="add">}\href{../../set6/html/Set.html#method-add}{\code{set6::Set$add()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="contains">}\href{../../set6/html/Set.html#method-contains}{\code{set6::Set$contains()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="initialize">}\href{../../set6/html/Set.html#method-initialize}{\code{set6::Set$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="print">}\href{../../set6/html/Set.html#method-print}{\code{set6::Set$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="remove">}\href{../../set6/html/Set.html#method-remove}{\code{set6::Set$remove()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="strprint">}\href{../../set6/html/Set.html#method-strprint}{\code{set6::Set$strprint()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="summary">}\href{../../set6/html/Set.html#method-summary}{\code{set6::Set$summary()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-equals"></a>}}
\if{latex}{\out{\hypertarget{method-equals}{}}}
\subsection{Method \code{equals()}}{
Tests if two sets are equal.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tuple$equals(x, all = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\link{Set} or vector of \link{Set}s.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
An object is equal to a Tuple if it contains all the same elements, and in the same order.
Infix operators can be used for:
\tabular{ll}{
Equal \tab \code{==} \cr
Not equal \tab \code{!=} \cr
}
}

\subsection{Returns}{
If \code{all} is \code{TRUE} then returns \code{TRUE} if all \code{x} are equal to the Set, otherwise
\code{FALSE}. If \code{all} is \code{FALSE} then returns a vector of logicals corresponding to each individual
element of \code{x}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Tuple$new(1,2) ==  Tuple$new(1,2)
Tuple$new(1,2) != Tuple$new(1,2)
Tuple$new(1,1) != Set$new(1,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isSubset"></a>}}
\if{latex}{\out{\hypertarget{method-isSubset}{}}}
\subsection{Method \code{isSubset()}}{
Test if one set is a (proper) subset of another
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tuple$isSubset(x, proper = FALSE, all = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{any. Object or vector of objects to test.}

\item{\code{proper}}{logical. If \code{TRUE} tests for proper subsets.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If using the method directly, and not via one of the operators then the additional boolean
argument \code{proper} can be used to specify testing of subsets or proper subsets. A Set is a proper
subset of another if it is fully contained by the other Set (i.e. not equal to) whereas a Set is a
(non-proper) subset if it is fully contained by, or equal to, the other Set.

When calling \verb{$isSubset} on objects inheriting from \link{Interval}, the method treats the interval as if
it is a \link{Set}, i.e. ordering and class are ignored. Use \verb{$isSubinterval} to test if one interval
is a subinterval of another.

Infix operators can be used for:
\tabular{ll}{
Subset \tab \code{<} \cr
Proper Subset \tab \code{<=} \cr
Superset \tab \code{>} \cr
Proper Superset \tab \code{>=}
}

An object is a (proper) subset of a Tuple if it contains all (some) of the same elements,
and in the same order.
}

\subsection{Returns}{
If \code{all} is \code{TRUE} then returns \code{TRUE} if all \code{x} are subsets of the Set, otherwise
\code{FALSE}. If \code{all} is \code{FALSE} then returns a vector of logicals corresponding to each individual
element of \code{x}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Tuple$new(1,2,3) < Tuple$new(1,2,3,4)
Tuple$new(1,3,2) < Tuple$new(1,2,3,4)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tuple$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
