% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set.R
\name{equals}
\alias{equals}
\alias{==.Set}
\alias{!=.Set}
\title{Are Two Sets Equal?}
\usage{
\method{==}{Set}(x, y)

\method{!=}{Set}(x, y)
}
\arguments{
\item{x}{Set}

\item{y}{Set}
}
\value{
If \code{all} is \code{TRUE} then returns \code{TRUE} if all \code{x} are equal to the Set, otherwise
\code{FALSE}. If \code{all} is \code{FALSE} then returns a vector of logicals corresponding to each individual
element of \code{x}.
}
\description{
Are Two Sets Equal?
}
\section{R6 Usage}{
 $equals(x, all = FALSE)
}

\examples{
# Equals
Set$new(1,2)$equals(Set$new(5,6))
Set$new(1,2)$equals(Interval$new(1,2))
Set$new(1,2) == Interval$new(1,2, class = "integer")

# Not equal
!Set$new(1,2)$equals(Set$new(1,2))
Set$new(1,2) != Set$new(1,5)
}
\seealso{
Other set methods: 
\code{\link{contains}},
\code{\link{isSubset}}
}
\concept{set methods}
