% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_FuzzySet.R
\name{alphaCut}
\alias{alphaCut}
\title{Get Elements in FuzzySet with Membership Greater than Alpha}
\arguments{
\item{alpha}{numeric in [0, 1] to determine which elements to return}

\item{strong}{logical, if \code{FALSE} (default) then includes elements greater than or equal to alpha, otherwise only strictly greater than}

\item{create}{logical, if \code{FALSE} (default) returns the elements in the alpha cut, otherwise returns a crisp set of the elements}
}
\value{
Elements in \link{FuzzySet} or a \link{Set} of the elements.
}
\description{
The alpha-cut of a fuzzy set is defined as the set
\deqn{A_\alpha = \{x \epsilon F | m \ge \alpha\}}{A_\alpha = {x \epsilon F | m \ge \alpha}}
where \eqn{x} is an element in the fuzzy set, \eqn{F}, and \eqn{m} is the corresponding membership.
}
\section{R6 Usage}{
 $alphaCut(alpha, strong = FALSE, create = FALSE)
}

\examples{
f = FuzzySet$new(1, 0.1, 2, 0.5, 3, 1)
# Alpha-cut
f$alphaCut(0.5)

# Strong alpha-cut
f$alphaCut(0.5, strong = TRUE)

# Create a set from the alpha-cut
f$alphaCut(0.5, create = TRUE)
}
\seealso{
\link{support}, \link{core}
}
