% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_variables.R
\name{summaryTortuosity}
\alias{summaryTortuosity}
\title{Calculate tortuosity}
\usage{
summaryTortuosity(summary.df, total.distance, net.displacement,
  inverse = FALSE)
}
\arguments{
\item{summary.df}{The summary data frame containing total distance and net
displacement for all movement paths}

\item{total.distance}{The unquoted variable name in a data frame containing
the total distance for all movement paths}

\item{net.displacement}{The unquoted variable name in a data frame containing
the net displacement for all movement paths.}

\item{inverse}{Defaults to \code{FALSE}. When set to \code{FALSE}, this
function calculates tortuosity as net displacement divided by total
distance. Setting inverse to \code{TRUE} causes the function to calculate
tortuosity as total distance divided by net displacement.}
}
\value{
The inputed data frame of numbers where each number corresponds to
  the tortuosity of a movement path. The numbers are ordered and named as
  they are in the data frames list.
}
\description{
Calculate the tortuosity, or straightness, of a movement path
}
\details{
To use this function, a summary data frame must already exist containing a
column for total distance and net displacement (in other words, your data
should have been processed by \code{summaryTotalDistance} and
\code{summaryNetDisplacement}.

Tortuosity is a measure of how straight a path is. There are different
methods for calculating path straightness. This function calculates
tortuosity as the quotient of net displacement and total distance by default.
The quotient can be reversed by setting inverse to \code{TRUE}.
}
\examples{
# Calculate tortuosity as the ratio of net displacement to total distance

summary_df <- data.frame(id = c(1, 2),
                         treatment = c("a", "b"),
                         date = c("2032018", "2042018"),
                         stimulus = c(0, 0),
                         total_distance = runif(2, 11, 20),
                         net_displacement = runif(2, 5, 10))

summary_df <- summaryTortuosity(summary.df = summary_df,
  total.distance = total_distance,
  net.displacement = net_displacement)

# Calculate tortuosity as the ratio of total distance to net displacement
# (the opposite of the previous example)

summary_df <- summaryTortuosity(summary.df = summary_df,
  total.distance = total_distance,
  net.displacement = net_displacement,
  inverse = TRUE)
}
