% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serp.vcov.R
\name{vcov.serp}
\alias{vcov.serp}
\title{Variance covariance matrix for a fitted serp object}
\usage{
\method{vcov}{serp}(object, ...)
}
\arguments{
\item{object}{An object of class \code{serp}.}

\item{...}{additional arguments.}
}
\value{
A variance covariance matrix of a fitted model.
}
\description{
Provides the Variance covariance matrix of an object of class \code{serp}.
}
\examples{
library(serp)
m <- serp(rating ~ temp + contact, slope = "parallel", link = "logit",
           data = serp::wine)
vcov(m)

}
\seealso{
\code{\link{serp}}

\code{\link{serp}}, \code{\link{anova.serp}}, \code{\link{confint.serp}}
}
