% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serp.method.R
\name{coef.serp}
\alias{coef.serp}
\alias{coefficients.serp}
\title{Coefficients for a fitted serp object}
\usage{
\method{coef}{serp}(object, ...)

\method{coefficients}{serp}(object, ...)
}
\arguments{
\item{object}{An object of class \code{serp}.}

\item{...}{additional arguments.}
}
\value{
A vector of model coefficients.
}
\description{
Returns the coefficients of a fitted object of class \code{serp}.
}
\examples{
library(serp)
m <- serp(rating ~ temp + contact, slope = "parallel", link = "loglog",
          data = wine)
coef(m)

}
\seealso{
\code{\link{serp}}, \code{\link{AIC.serp}}, \code{\link{BIC.serp}},
\code{\link{logLik.serp}}
}
