% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serp.method.R
\name{BIC.serp}
\alias{BIC.serp}
\title{BIC for a fitted serp object}
\usage{
\method{BIC}{serp}(object, ...)
}
\arguments{
\item{object}{An object of class \code{serp}.}

\item{...}{additional arguments.}
}
\value{
A single numeric value of the model.
}
\description{
Returns the bayesian information criterion of a fitted object of class
\code{serp}. For the penalized slopes, the effective degrees of freedom (edf)
is obtained from the trace of the generalized hat matrix which depends on
the tuning parameter.
}
\examples{
library(serp)
m <- serp(rating ~ temp + contact, slope = "parallel", link = "loglog",
          data = wine)
BIC(m)
}
\seealso{
\code{\link{serp}}, \code{\link{AIC.serp}}, \code{\link{coef.serp}},
\code{\link{logLik.serp}},
}
