% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MkAgePrior.R
\name{MakeAgeprior}
\alias{MakeAgeprior}
\title{Age priors}
\usage{
MakeAgeprior(Parents = NULL, LifeHistData = NULL, UseParents = TRUE,
  nAgeClasses = 0)
}
\arguments{
\item{Parents}{dataframe with scaffold pedigree of assigned parents;
columns id - dam - sire.}

\item{LifeHistData}{dataframe with 3 columns:
\itemize{
\item{ID: }{max. 30 characters long,}
\item{Sex: }{1 = females, 2 = males, other numbers = unkown,}
\item{Birth Year: }{(or hatching year) Negative numbers (and NA's) are
  interpreted as missing.}}}

\item{UseParents}{use the age distribution of assigned parents. Otherwise,
equal probabilities across all age differences are assumed.}

\item{nAgeClasses}{number of age classes; age prior matrix will have
nAgeClasses + 1 rows.}
}
\value{
A matrix with the probability ratio of the (absolute) age difference
between two individuals conditional on them being a certain type of relative
versus being a random draw from the sample.

Using Bayes' theorem,
\deqn{P(relationship | age difference) = P(age difference | relationship) /
P(age difference) * P(relationship)}
and the values here are multiplied by the age-independent genetic-only
 \eqn{P(relationship)} inside \code{\link{sequoia}}.

  One row per age difference (0 - nAgeClasses), and one column for
  each relationship type, with abbreviations:
     \item{M}{Mothers}
     \item{P}{Fathers}
     \item{MGM}{Maternal grandmother}
     \item{PGF}{Paternal grandfather}
     \item{MGF}{Maternal grandfathers and paternal grandmothers}
     \item{FS}{Full siblings}
     \item{MS}{Maternal siblings}
     \item{PS}{Paternal siblings}
     \item{UA}{Avuncular}

For siblings and avuncular relationships absolute age differences are used,
as when generations overlap, nephews can be older than their aunts.
}
\description{
Calculate age-difference based prior probability ratios for
 various categories of pairwise relatives.
}
\details{
if UseParents = TRUE, Retrieve age distributions of maternal
& paternal parents, siblings and grandparents from assigned parents, to use
as input for sibship clustering and grandparent assignment.
If the lifehistory file indicates a single age class, \eqn{MS = PS = 1} and
 \eqn{MGM = PGF = MGF = UA = 0}.
}
