% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateCompare.R
\name{SimGeno}
\alias{SimGeno}
\title{Simulated genotypes}
\usage{
SimGeno(Ped = NULL, PedFile = NULL, MafFile = NULL, OutFile = NA,
  nSnp = 400, nGen = 10, PropLQ = 0, MisHQ = 0.005, MisLQ = 0.3,
  ParMis = 0.4, ErHQ = 5e-04, ErLQ = 0.005, quiet = FALSE)
}
\arguments{
\item{Ped}{Dataframe, pedigree with columns ID - dam - sire; additional
columns are ignored.}

\item{PedFile}{name of a pedigree file.}

\item{MafFile}{(optional) file with minor allele frequency at each locus.
If none specified, allele frequencies will be sampled from a uniform
distribution between 0.3 and 0.5.}

\item{OutFile}{filename for simulated genotypes. If NA, return
matrix with genotypes in console.}

\item{nSnp}{number of SNPs to simulate.}

\item{nGen}{maximum number of generations to consider.}

\item{PropLQ}{proportion of low-quality samples.}

\item{MisHQ}{average missingness for high-quality samples, assuming a
beta-disstribution with alpha = 1.}

\item{MisLQ}{average missingness in low-quality samples.}

\item{ParMis}{proportion of parents with fully missing genotype.}

\item{ErHQ}{error rate in high quality samples (defaults to 0.005).}

\item{ErLQ}{error rate in low quality samples.}

\item{quiet}{suppress messages.}
}
\value{
A matrix with genotype data encoded as 0/1/2/-9, in a format
  similar to that generated by Plink's --recodeA option. The matrix is
  written to a specified textfile unless OutFile=NA.
}
\description{
Simulate SNP genotype data from a pedigree, with optional missingess and
 errors.
}
\details{
Provide either a pedigree dataframe, or the name of a text file containing
  the pedigree. Please ensure the pedigree is a valid pedigree, for example
  by first running fixPedigree() from library Pedantics.
}
\examples{
data(Ped_HSg5)
GenoM <- SimGeno(Ped = Ped_HSg5, nSnp = 100, ParMis = 0.2)

}
\author{
Jisca Huisman, \email{jisca.huisman@gmail.com}
}

