% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqminer.R
\name{readBGENToListByRange}
\alias{readBGENToListByRange}
\title{Read information from BGEN file in a given range and return a list}
\usage{
readBGENToListByRange(fileName, range)
}
\arguments{
\item{fileName}{character, represents an input BGEN file (Bgzipped, with Tabix index)}

\item{range}{character, a text indicating which range in the BGEN file to extract. e.g. 1:100-200, 1-based index}
}
\value{
a list of chrom, pos, varid, rsid, alleles, isPhased, probability, sampleId
}
\description{
Read information from BGEN file in a given range and return a list
}
\examples{
fileName = system.file("bgen/all.anno.filtered.extract.bgen", package = "seqminer")
cfh <- readBGENToListByRange(fileName, "1:196621007-196716634")
}
\seealso{
http://zhanxw.com/seqminer/ for online manual and examples
}
