\name{rvmeta.readDataByRange}
\alias{rvmeta.readDataByRange}
\title{Read association statistics by range from METAL-format files. Both score statistics and covariance statistics will be extracted.}
\usage{
  rvmeta.readDataByRange(scoreTestFiles, covFiles, ranges)
}
\arguments{
  \item{scoreTestFiles}{character vector, score test output
  files (rvtests outputs using --meta score)}

  \item{covFiles}{character vector, covaraite files
  (rvtests outputs using --meta cov)}

  \item{ranges}{character, a text indicating which range in
  the VCF file to extract. e.g. 1:100-200}
}
\value{
  a list of statistics including chromosome, position,
  allele frequency, score statistics, covariance and
  annotation(if input files are annotated).
}
\description{
  Read association statistics by range from METAL-format
  files. Both score statistics and covariance statistics
  will be extracted.
}
\examples{
scoreFileName = system.file("rvtests/rvtest.MetaScore.assoc.anno.gz", package = "seqminer")
covFileName = system.file("rvtests/rvtest.MetaCov.assoc.gz", package = "seqminer")
geneFile = system.file("vcf/refFlat_hg19_6col.txt.gz", package = "seqminer")
cfh <- rvmeta.readDataByRange(scoreFileName, covFileName, "1:196621007-196716634")
}
\seealso{
  http://zhanxw.com/seqminer/ for online manual and
  examples
}

