% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{A_optimal_cat}
\alias{A_optimal_cat}
\title{Get the most informative subjects from unlabeled dataset for the
  categorical case}
\usage{
A_optimal_cat(X, beta, W, unlabeledIDs)
}
\arguments{
\item{X}{A matrix containing all the samples except their labels including
the labeled samples and the unlabeled samples.}

\item{beta}{A matrix contains the estimated coefficient. Note that the beta
is a n * k matrix which n is the number of the explanatory variables and
k+1 is the number of categories}

\item{W}{A matrix denotes the inverse information matrix of the coefficient
beta.}

\item{unlabeledIDs}{A numeric vector for the unique identification of the
unlabeled. dataset.}
}
\value{
a index of the most informative subjects from unlabeled dataset for
  the categorical case
}
\description{
Get the most informative subjects from unlabeled dataset under
  the categorical case.
}
\details{
A_optimal_cat uses the A optimality criterion from the experimental design
to choose the most informative subjects under the the categorical case. We
have obtained the variance-covariance matrix based on the current labeled
samples which indicates how much information there is. Then we should
repeatly calculate the information matrix after we choose a sample from the
unlabeled dataset. Once we finish the iteration, we pick the sample which
has the most information.
}
