% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_to_sc_data.R
\name{mc_to_sc_data}
\alias{mc_to_sc_data}
\title{Merge Multiple Sequence Objects to One (Multichannel to Single Channel Data)}
\usage{
mc_to_sc_data(data, combine_missing = TRUE, all_combinations = FALSE)
}
\arguments{
\item{data}{A list of state sequence objects created with the \code{\link{seqdef}} function.}

\item{combine_missing}{Controls whether combined states of observations are
coded missing (\code{NA}) if some of the channels include missing information.
Defaults to \code{TRUE}.}

\item{all_combinations}{Controls whether all possible combinations of
observed states are included in the single channel representation or only
combinations that are found in the data. Defaults to \code{FALSE}, i.e.
only actual observations are included.}
}
\description{
Function \code{mc_to_sc_data} combines observed states of multiple sequence objects into one.
}
\examples{

ssplot(hmm_biofam$observations)
ssplot(mc_to_sc_data(hmm_biofam$observations))

}
\seealso{
\code{\link{seqdef}} for creating state sequence objects.
}

