\name{nhppSimConstWindowAnalysis}
\alias{nhppSimConstWindowAnalysis}
\title{
Analyze the performance on simulation with constant signal length in each set
}
\description{
Takes the dataset and metafile output of \code{\link{nhppSimConstWindowGen}} and of SegSeq, then evaluates the performance in change-point precision and recall. The dataset must be generated in such format for this function to work.
}
\usage{
nhppSimConstWindowAnalysis(filePrefix, chromosomeN, distMetric=c(20,50,100,150,200,300,500,1000), cptLen=c(3,5,8,12,15,20,30,50,100), nPair=2, nRepeat=10, statistic="normal", grid.size="auto", takeN=5, maxNCut=60, minStat=5, verbose=FALSE, timing=TRUE, hasRun=FALSE, width=12, height=6)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{filePrefix}{
The first part of the filename for data and metafile generated by \code{\link{nhppSimConstWindowGen}}
}
	\item{chromosomeN}{
The number indicating the chromosome number the dataset emulates
}
	\item{distMetric}{
A set of criterions of determining change points called are true. A call is deemed true if an actual signal change points within x number of reads is matched to it, after a minimum-cost bipartite matching. Larger value is a looser criterion.
}
  \item{cptLen}{
The second part of the filename for data and metafile generated by \code{\link{nhppSimConstWindowGen}}, indicating the length of the true signal. Constant width of the signal (CN gain or loss) region to simulate, can be a vector of different values for which to test
}
  \item{nPair}{
A part of the filename for data and metafile generated by \code{\link{nhppSimConstWindowGen}}, indicating the number of normal/tumor pair. Number of tumor samples to generate for each choice of the width of the signal; number of normal samples to generate
}
  \item{nRepeat}{
A part of the filename for data and metafile generated by \code{\link{nhppSimConstWindowGen}}. Number of times to repeat the simulation data generation
}
  \item{statistic}{
The type of statistic to use for the analysis
}
  \item{grid.size}{
Argument to \code{\link{ScanCBS}}
}
  \item{takeN}{
Argument to \code{\link{ScanCBS}}
}
  \item{maxNCut}{
Argument to \code{\link{ScanCBS}}
}
  \item{minStat}{
Argument to \code{\link{ScanCBS}}
}
  \item{verbose}{
If \code{TRUE}, will print run information as the algorithm proceeds
}
  \item{timing}{
Performs timing of the \code{\link{ScanCBS}} algorithm
}
  \item{hasRun}{
If \code{TRUE}, will read the output file of \code{\link{ScanCBS}} instead of run it on these datasets again. Only use when the same call to \code{\link{ScanCBS}} has been used before in this function call.
}
  \item{width}{
Width of the graph output file
}
  \item{height}{
Height of the graph output file
}
}
\details{
This function is used in conjunction with \code{\link{nhppSimConstWindowGen}}. It reads in the data and metafile output of the said function, and compares the performance of our algorithm with SegSeq. It is important that SegSeq has been used on the simulation datasets generated before using this.
}
\value{
  \item{simCBS }{Result of \code{\link{ScanCBS}} output structure}
  \item{CBSMatchDist }{The distance among reads after minimum-cost bipartite graph matching for our algorithm}
  \item{SegMatchDist }{The distance among reads after minimum-cost bipartite graph matching for SegSeq}
  \item{CBSRecall, SegRecall }{The recall rates of two algorithms}
  \item{CBSPrecision, SegPrecision }{The precision rates of two algorithms}
  \item{CBSFMeasure, SegFMeasure }{The F-measure of two algorithms}
  \item{trueTauMeanSigLen }{The mean distance between true signal boundaries}
  \item{nTrueTau }{The number of true change points}
  \item{nCBSCall, nSegCall }{Number of change points called by the two algorithms}
  \item{CBSTime }{Mean computational time of \code{\link{ScanCBS}} for each signal length}
}

\author{
Jeremy J. Shen
}

\seealso{
\code{\link{nhppSimConstWindowGen}}
}