% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeSeries.R
\name{sentopics_sentiment}
\alias{sentopics_sentiment}
\alias{sentopics_sentiment<-}
\title{Internal sentiment}
\usage{
sentopics_sentiment(
  x,
  method = c("proportional", "proportionalPol"),
  override = FALSE,
  quiet = FALSE,
  include_docvars = FALSE
)

sentopics_sentiment(x) <- value
}
\arguments{
\item{x}{a \code{sentopicmodel} created from the \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}}, \code{\link[=rJST]{rJST()}} or
\code{\link[=sentopicmodel]{sentopicmodel()}} function}

\item{method}{the method used to compute sentiment, see "Methods" below.
Ignored if an internal sentiment is already stored, unless \code{override} is
\code{TRUE}.}

\item{override}{by default, the function computes sentiment only if no
internal sentiment is already stored within the \code{sentopicmodel} object.
This avoid, for example, erasing externally provided sentiment. Set to
\code{TRUE} to force computation of new sentiment values. Only useful for models
with a sentiment layer.}

\item{quiet}{if \code{FALSE}, print a message when internal sentiment is found.}

\item{include_docvars}{if \code{TRUE} the function will return all docvars stored
in the internal \code{tokens} object of the model}

\item{value}{a numeric vector of sentiment to input into the model.}
}
\value{
A data.frame with the stored sentiment per document.
}
\description{
Compute, extract or replace the internal sentiment of a
\code{sentopicmodel}. The internal sentiment is used to create time series using
the functions \code{\link[=sentiment_series]{sentiment_series()}} or \code{\link[=sentiment_topics]{sentiment_topics()}}. If the input
model contains a sentiment layer, sentiment can be computed directly from
the output of the model. Otherwise, sentiment obtained externally should be
added for each document.
}
\details{
The computed sentiment varies depending on the model. For \link{LDA},
sentiment computation is not possible.

For \link{JST}, the sentiment is computed on a per-document basis according to
the document-level sentiment mixtures.

For a \link{rJST} model, a sentiment is computed for each topic, resulting in
\code{K} sentiment values per document. In that case, the \code{.sentiment} column is
an average of the \code{K} sentiment values, weighted by they respective topical
proportions.
}
\note{
The internal sentiment is stored internally in the \emph{docvars} of the
topic model. This means that sentiment may also be accessed through the
\code{\link[=docvars]{docvars()}} function, although this is discouraged.
}
\section{Methods}{


The function accepts two methods of computing sentiment:
\itemize{
\item \strong{proportional} computes the difference between the estimated positive
and negative proportions for each document (and possibly each topic).
\deqn{positive - negative}
\item \strong{proportionalPol} computes the difference between positive and negative
proportions, divided by the sum of positive and negative proportions. As a
result, the computed sentiment lies within the (-1;1) interval.
\deqn{\frac{positive - negative}{positive + negative}}{(positive -
  negative) / (positive + negative)}
}

Both methods will lead to the same result for a JST model containing only
negative and positive sentiments.
}

\examples{
\donttest{# example dataset already contains ".sentiment" docvar
docvars(ECB_press_conferences_tokens)
# sentiment is automatically stored in the sentopicmodel object
lda <- LDA(ECB_press_conferences_tokens)
sentopics_sentiment(lda)

# sentiment can be removed or modified by the assignment operator
sentopics_sentiment(lda) <- NULL
sentopics_sentiment(lda) <- docvars(ECB_press_conferences_tokens, ".sentiment")

# for JST models, sentiment can be computed from the output of the model
jst <- JST(ECB_press_conferences_tokens, lexicon = LoughranMcDonald)
jst <- grow(jst, 100)
sentopics_sentiment(jst, override = TRUE) # replace existing sentiment

## for rJST models one sentiment value is computed by topic
rjst <- rJST(ECB_press_conferences_tokens, lexicon = LoughranMcDonald)
rjst <- grow(rjst, 100)
sentopics_sentiment(rjst, override = TRUE)}
}
\seealso{
Other sentopics helpers: 
\code{\link{sentopics_date}()},
\code{\link{sentopics_labels}()}
}
\author{
Olivier Delmarcelle
}
\concept{sentopics helpers}
